Imports System.Drawing.Drawing2D
Public Class Form1
    Inherits System.Windows.Forms.Form

    ' Les images.
    Private bMapImageA As Image
    Private bMapImageB As Image
    Private bMapImageC As Image

    ' Rectangles pour les images.
    Private rectA As Rectangle = New Rectangle(10, 10, 90, 90)
    Private rectB As Rectangle = New Rectangle(10, 110, 90, 90)
    Private rectC As Rectangle = New Rectangle(10, 210, 90, 90)

    ' Une rgion polygonale.
    Private myPath As GraphicsPath = New GraphicsPath()

    ' Ont-ils cliqu sur une image ?
    Private isImageClicked As Boolean = False
    Private imageClicked As Integer


#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'Cet appel est requis par le concepteur Windows Form.
        InitializeComponent()

        ' Remplir les images avec les bitmaps.
        bMapImageA = New Bitmap("imageA.bmp")
        bMapImageB = New Bitmap("imageB.bmp")
        bMapImageC = New Bitmap("imageC.bmp")

        ' Crer une rgion d'intret.
        myPath.StartFigure()
        myPath.AddLine(New Point(150, 10), New Point(120, 150))
        myPath.AddArc(200, 200, 100, 100, 0, 90)
        Dim point1 As Point = New Point(250, 250)
        Dim point2 As Point = New Point(350, 275)
        Dim point3 As Point = New Point(350, 325)
        Dim point4 As Point = New Point(250, 350)
        Dim points As Point() = {point1, point2, point3, point4}
        myPath.AddCurve(points)
        myPath.CloseFigure()

        CenterToScreen()

    End Sub

    'La classe Form surcharge la mthode dispose pour nettoyer la liste de composants.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Requis par le Concepteur Windows Form
    Private components As System.ComponentModel.Container

    'NOTE: La procdure suivante est requise par le Concepteur Windows Form
    'Elle peut tre modifie en utilisant le Concepteur Windows Form.  
    'Ne pas la modifier en utilisant le Concepteur Windows Form.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        '
        'Form1
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(368, 357)
        Me.Name = "Form1"
        Me.Text = "Images"

    End Sub

#End Region

    Private Sub Form1_Paint(ByVal sender As Object, ByVal e As System.Windows.Forms.PaintEventArgs) Handles MyBase.Paint
        Dim g As Graphics = e.Graphics

        ' Dessiner les trois images.
        g.DrawImage(bMapImageA, rectA)
        g.DrawImage(bMapImageB, rectB)
        g.DrawImage(bMapImageC, rectC)

        ' Afficher le chemin des images.
        g.FillPath(Brushes.DarkGreen, myPath)

        ' Dessiner l'encadr (si cliqu...)
        If (isImageClicked = True) Then

            Dim outline As Pen = New Pen(Color.Red, 5)

            Select Case (imageClicked)
                Case 0
                    g.DrawRectangle(outline, rectA)
                Case 1
                    g.DrawRectangle(outline, rectB)
                Case 2
                    g.DrawRectangle(outline, rectC)
                Case 3
                    g.DrawPath(outline, myPath)
            End Select
        End If
    End Sub

    Private Sub Form1_MouseUp(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles MyBase.MouseUp
        ' Rcuprer les coordonnes (x, y) du clic de souris.
        Dim mousePt As Point = New Point(e.X, e.Y)
        ' Vrifier si la souris est quelques part dans une des trois rgions...
        If (rectA.Contains(mousePt)) Then
            isImageClicked = True
            imageClicked = 0
            Me.Text = "Vous avez cliqu sur l'image A"
        ElseIf (rectB.Contains(mousePt)) Then
            isImageClicked = True
            imageClicked = 1
            Me.Text = "Vous avez cliqu sur l'image B"
        ElseIf (rectC.Contains(mousePt)) Then
            isImageClicked = True
            imageClicked = 2
            Me.Text = "Vous avez cliqu sur l'image C"
        ElseIf (myPath.IsVisible(mousePt)) Then
            isImageClicked = True
            imageClicked = 3
            Me.Text = "Vous avez cliqu sur la forme trange..."
        Else ' S'il n'est dans aucune des zones, definir les valeurs par dfaut.
            isImageClicked = False
            Me.Text = "Images"
        End If
        ' Redessiner la zone cliente.
        Invalidate()
    End Sub
End Class
